/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer.blocks;

import java.nio.FloatBuffer;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import noppes.npcs.blocks.tiles.CustomTileEntityPortal;

public class BlockPortalRenderer<T extends CustomTileEntityPortal>
extends TileEntitySpecialRenderer<T> {
    private static final Random RANDOM = new Random(31100L);
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    private final FloatBuffer buffer = GLAllocation.func_74529_h((int)16);

    private FloatBuffer getBuffer(float red, float green, float blue) {
        this.buffer.clear();
        this.buffer.put(red).put(green).put(blue).put(0.0f);
        this.buffer.flip();
        return this.buffer;
    }

    protected int getPasses(double distance) {
        int i = distance > 36864.0 ? 1 : (distance > 25600.0 ? 3 : (distance > 16384.0 ? 5 : (distance > 9216.0 ? 7 : (distance > 4096.0 ? 9 : (distance > 1024.0 ? 11 : (distance > 576.0 ? 13 : (distance > 256.0 ? 14 : 15)))))));
        return i;
    }

    public void render(@Nullable T te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te == null) {
            return;
        }
        GlStateManager.func_179140_f();
        RANDOM.setSeed(31100L);
        GlStateManager.func_179111_a((int)2982, (FloatBuffer)MODELVIEW);
        GlStateManager.func_179111_a((int)2983, (FloatBuffer)PROJECTION);
        int i = this.getPasses(x * x + y * y + z * z);
        boolean isPortalTexture = false;
        for (int j = 0; j < i; ++j) {
            GlStateManager.func_179094_E();
            float f1 = (1.25f / (float)i * (float)j + 0.5f) / (float)(18 - j);
            if (j == 0) {
                this.func_147499_a(((CustomTileEntityPortal)((Object)te)).getSkyTexture());
                f1 = 5.0f;
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (j >= 1) {
                this.func_147499_a(((CustomTileEntityPortal)((Object)te)).getPortalTexture());
                isPortalTexture = true;
                Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
            }
            if (j == 1) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9216);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9216);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9216);
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9474, (FloatBuffer)this.getBuffer(1.0f, 0.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 1.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 0.0f, 1.0f));
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            float f2 = j + 1;
            float t0 = ((CustomTileEntityPortal)((Object)te)).speed * 1000.0f;
            GlStateManager.func_179109_b((float)(17.0f / f2), (float)((2.0f + f2 / 1.5f) * ((float)Minecraft.func_71386_F() % t0 / t0)), (float)0.0f);
            GlStateManager.func_179114_b((float)((f2 * f2 * 4321.0f + f2 * 9.0f) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)(4.5f - f2 / 4.0f), (float)(4.5f - f2 / 4.0f), (float)1.0f);
            GlStateManager.func_179110_a((FloatBuffer)PROJECTION);
            GlStateManager.func_179110_a((FloatBuffer)MODELVIEW);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float f3 = (RANDOM.nextFloat() * 0.5f + 0.1f) * f1;
            float f4 = (RANDOM.nextFloat() * 0.5f + 0.4f) * f1;
            float f5 = (RANDOM.nextFloat() * 0.5f + 0.5f) * f1;
            float f6 = ((CustomTileEntityPortal)((Object)te)).alpha;
            if (f6 < 0.15f) {
                f6 = 0.15f;
            } else if (f6 > 1.0f) {
                f6 = 1.0f;
            }
            if (((CustomTileEntityPortal)((Object)te)).func_184313_a(EnumFacing.SOUTH)) {
                bufferbuilder.func_181662_b(x, y, z + 0.75).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z + 0.75).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z + 0.75).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 1.0, z + 0.75).func_181666_a(f3, f4, f5, f6).func_181675_d();
            }
            if (((CustomTileEntityPortal)((Object)te)).func_184313_a(EnumFacing.NORTH)) {
                bufferbuilder.func_181662_b(x, y + 1.0, z + 0.25).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z + 0.25).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z + 0.25).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x, y, z + 0.25).func_181666_a(f3, f4, f5, f6).func_181675_d();
            }
            if (((CustomTileEntityPortal)((Object)te)).func_184313_a(EnumFacing.EAST)) {
                bufferbuilder.func_181662_b(x + 0.75, y + 1.0, z).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 0.75, y + 1.0, z + 1.0).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 0.75, y, z + 1.0).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 0.75, y, z).func_181666_a(f3, f4, f5, f6).func_181675_d();
            }
            if (((CustomTileEntityPortal)((Object)te)).func_184313_a(EnumFacing.WEST)) {
                bufferbuilder.func_181662_b(x + 0.25, y, z).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 0.25, y, z + 1.0).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 0.25, y + 1.0, z + 1.0).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 0.25, y + 1.0, z).func_181666_a(f3, f4, f5, f6).func_181675_d();
            }
            if (((CustomTileEntityPortal)((Object)te)).func_184313_a(EnumFacing.DOWN)) {
                bufferbuilder.func_181662_b(x, y + 0.25, z).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 0.25, z).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 0.25, z + 1.0).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 0.25, z + 1.0).func_181666_a(f3, f4, f5, f6).func_181675_d();
            }
            if (((CustomTileEntityPortal)((Object)te)).func_184313_a(EnumFacing.UP)) {
                bufferbuilder.func_181662_b(x, y + 0.75, z + 1.0).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 0.75, z + 1.0).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 0.75, z).func_181666_a(f3, f4, f5, f6).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 0.75, z).func_181666_a(f3, f4, f5, f6).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            this.func_147499_a(((CustomTileEntityPortal)((Object)te)).getSkyTexture());
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.R);
        GlStateManager.func_179145_e();
        if (isPortalTexture) {
            Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
        }
    }
}

